import { App } from '@kevisual/router'
import { fork } from 'child_process'
const app = new App()
import path from 'path'

// http://localhost:3000/api/router?path=call
app.route({
  path: 'call'
}).define(async (ctx) => {
  ctx.body = 'Hello World'
  const pwd = process.cwd()
  const testA = path.join(pwd, 'src/test/a.ts')
  const child = fork(testA, {
  })
  console.log('Child process started with PID:', child.pid)
  child.on('message', (msg) => {
    console.log('Message from child', msg)
    setTimeout(() => {
      console.log('child process connected:', child.connected)
      console.log('child process killed:', child.killed)
      console.log('child process exit code:', child.exitCode)
    }, 20)
  })

  child.on('exit', (code, signal) => {
    console.log('子进程已退出，退出码:', code, '信号:', signal)
  })

  child.on('close', (code, signal) => {
    console.log('子进程已关闭，退出码:', code, '信号:', signal)
  })
  child.send({ hello: 'world' })

}).addTo(app)

app.listen(3000, () => {
  console.log('Server is running on http://localhost:3000')
})